// UPWORK PRO v6.3
var myProfile = null, allProfiles = {}, currentProfileId = 'default', isNewUser = false, pendingEmail = '';
var history = { profiles: [], proposals: [], titles: [] }, scrapedProfiles = [];

document.addEventListener('DOMContentLoaded', async function() {
  setupEvents(); loadData();
  var loggedIn = await APIService.init();
  if (loggedIn) { var v = await APIService.verify(); if (v.success) { showApp(); checkPendingTaskResult(); } else showAuth(); }
  else showAuth();
});

// Check if there's a pending task result from background
async function checkPendingTaskResult() {
  try {
    chrome.runtime.sendMessage({ action: 'getTaskStatus' }, function(response) {
      if (response && response.result) {
        // There's a completed result waiting
        var result = response.result;
        
        if (result.type === 'optimize' && result.success) {
          // Show optimization results
          handleOptimizeResult(result.content, result.credits);
          showStatus('Previous optimization complete!', 'success');
        } else if (result.type === 'proposal' && result.success) {
          // Show proposal results
          document.getElementById('proposalResult').classList.remove('hidden');
          document.getElementById('proposalText').textContent = result.content.trim();
          document.getElementById('credits').textContent = '💎 ' + result.credits;
          showStatus('Previous proposal complete!', 'success');
        }
        
        // Clear the result
        chrome.runtime.sendMessage({ action: 'clearTaskResult' });
        
        // Update credits display
        if (result.credits !== undefined) {
          document.getElementById('credits').textContent = '💎 ' + result.credits;
        }
      } else if (response && response.pending) {
        // Task still processing - show loading
        showStatus('Processing in background...', 'loading');
      }
    });
  } catch (e) {
    console.log('No pending task');
  }
}

function showAuth() { document.getElementById('authScreen').classList.remove('hidden'); document.getElementById('mainApp').classList.add('hidden'); showLoginForm(); }
function showApp() { document.getElementById('authScreen').classList.add('hidden'); document.getElementById('mainApp').classList.remove('hidden'); updateUI(); if(isNewUser){showModal('welcomeModal');isNewUser=false;} }

function showLoginForm() { document.getElementById('loginForm').classList.remove('hidden'); document.getElementById('signupForm').classList.add('hidden'); document.getElementById('otpForm').classList.add('hidden'); document.getElementById('forgotForm').classList.add('hidden'); document.getElementById('resetForm').classList.add('hidden'); }
function showSignupForm() { document.getElementById('loginForm').classList.add('hidden'); document.getElementById('signupForm').classList.remove('hidden'); document.getElementById('otpForm').classList.add('hidden'); document.getElementById('forgotForm').classList.add('hidden'); document.getElementById('resetForm').classList.add('hidden'); }
function showOtpForm(email) { pendingEmail=email; document.getElementById('otpEmail').textContent=email; document.getElementById('loginForm').classList.add('hidden'); document.getElementById('signupForm').classList.add('hidden'); document.getElementById('otpForm').classList.remove('hidden'); }
function showForgotForm() { document.getElementById('loginForm').classList.add('hidden'); document.getElementById('forgotForm').classList.remove('hidden'); }
function showResetForm(email) { pendingEmail=email; document.getElementById('forgotForm').classList.add('hidden'); document.getElementById('resetForm').classList.remove('hidden'); }

function showAuthError(m) { var e=document.getElementById('authError'); e.textContent=m; e.classList.remove('hidden'); setTimeout(function(){e.classList.add('hidden');},4000); }
function showAuthSuccess(m) { var e=document.getElementById('authSuccess'); e.textContent=m; e.classList.remove('hidden'); setTimeout(function(){e.classList.add('hidden');},4000); }
function showStatus(m,t) { var e=document.getElementById('status'); e.textContent=m; e.className='status '+t; e.classList.remove('hidden'); if(t!=='loading')setTimeout(function(){e.classList.add('hidden');},3000); }
function showModal(id) { document.getElementById(id).classList.remove('hidden'); }
function hideModal(id) { document.getElementById(id).classList.add('hidden'); }

async function doLogin() {
  var email=document.getElementById('loginEmail').value.trim(), pass=document.getElementById('loginPassword').value;
  if(!email||!pass) return showAuthError('Enter email and password');
  document.getElementById('authLoading').classList.remove('hidden');
  var r=await APIService.login(email,pass);
  document.getElementById('authLoading').classList.add('hidden');
  if(r.success){if(r.needsVerification){showOtpForm(email);showAuthSuccess('Verify email');}else showApp();}
  else showAuthError(r.error||'Login failed');
}

async function doSignup() {
  var name=document.getElementById('signupName').value.trim(), email=document.getElementById('signupEmail').value.trim();
  var phone=document.getElementById('signupPhone').value.trim(), pass=document.getElementById('signupPassword').value;
  if(!name||!email||!pass) return showAuthError('Fill all fields');
  if(pass.length<6) return showAuthError('Password min 6 chars');
  document.getElementById('authLoading').classList.remove('hidden');
  var r=await APIService.signup(name,email,pass,phone);
  document.getElementById('authLoading').classList.add('hidden');
  if(r.success){if(r.needsVerification){showOtpForm(email);showAuthSuccess('Check email');}else{isNewUser=true;showApp();}}
  else showAuthError(r.error||'Signup failed');
}

async function doVerifyOtp() {
  var code=document.getElementById('otpCode').value.trim();
  if(!code||code.length!==6) return showAuthError('Enter 6-digit code');
  document.getElementById('authLoading').classList.remove('hidden');
  var r=await APIService.verifyOtp(pendingEmail,code);
  document.getElementById('authLoading').classList.add('hidden');
  if(r.success){isNewUser=true;showApp();}else showAuthError(r.error||'Invalid code');
}

async function doResendOtp() {
  document.getElementById('authLoading').classList.remove('hidden');
  var r=await APIService.resendOtp(pendingEmail);
  document.getElementById('authLoading').classList.add('hidden');
  if(r.success)showAuthSuccess('Code sent!');else showAuthError(r.error||'Failed');
}

async function doSendReset() {
  var email=document.getElementById('forgotEmail').value.trim();
  if(!email) return showAuthError('Enter email');
  document.getElementById('authLoading').classList.remove('hidden');
  var r=await APIService.forgotPassword(email);
  document.getElementById('authLoading').classList.add('hidden');
  if(r.success){showResetForm(email);showAuthSuccess('Code sent!');}else showAuthError(r.error||'Failed');
}

async function doResetPassword() {
  var code=document.getElementById('resetCode').value.trim(), newPass=document.getElementById('newPassword').value, confirmPass=document.getElementById('confirmPassword').value;
  if(code.length!==6) return showAuthError('Enter 6-digit code');
  if(newPass.length<6) return showAuthError('Password min 6 chars');
  if(newPass!==confirmPass) return showAuthError('Passwords do not match');
  document.getElementById('authLoading').classList.remove('hidden');
  var r=await APIService.resetPassword(pendingEmail,code,newPass);
  document.getElementById('authLoading').classList.add('hidden');
  if(r.success){showLoginForm();showAuthSuccess('Password reset!');}else showAuthError(r.error||'Failed');
}

function updateUI() {
  var user=APIService.getUser(); if(!user)return;
  document.getElementById('userName').textContent=user.name||'User';
  document.getElementById('credits').textContent='💎 '+(user.credits||0);
  if(user.credits>0&&user.credits<=2)document.getElementById('lowCreditsWarning').classList.remove('hidden');
  else document.getElementById('lowCreditsWarning').classList.add('hidden');
  document.getElementById('settingsName').textContent=user.name||'-';
  document.getElementById('settingsEmail').textContent=user.email||'-';
  document.getElementById('settingsCredits').textContent=user.credits||0;
  document.getElementById('settingsType').textContent=user.total_purchased>0?'⭐ Premium':'Free';
  if(user.total_purchased>0){document.getElementById('proposalLock').classList.add('hidden');document.getElementById('proposalTool').classList.remove('hidden');}
  updateProfileSelector();
}

function openUpworkSearch() {
  var kw=document.getElementById('keyword').value.trim();
  if(!kw){showStatus('Enter keyword','error');return;}
  // Clear old scraped data when opening new search
  scrapedProfiles=[];
  document.getElementById('scrapedData').classList.add('hidden');
  document.getElementById('competitorInput').value='';
  chrome.tabs.create({url:'https://www.upwork.com/nx/search/talent/?q='+encodeURIComponent(kw)});
  showStatus('Upwork opened! Wait for page to load, then click Scrape','success');
}

async function scrapeCompetitors() {
  showStatus('Scraping...','loading');
  // Get the currently active tab first
  var activeTabs = await chrome.tabs.query({active: true, currentWindow: false});
  var upworkTab = null;
  
  // Check if active tab is Upwork search
  for(var i=0;i<activeTabs.length;i++){
    if(activeTabs[i].url&&activeTabs[i].url.includes('upwork.com')&&activeTabs[i].url.includes('search')){
      upworkTab=activeTabs[i];
      break;
    }
  }
  
  // If no active Upwork tab, get the most recently opened Upwork search tab
  if(!upworkTab){
    var allTabs=await chrome.tabs.query({});
    // Sort by id descending (most recent first)
    allTabs.sort(function(a,b){return b.id-a.id;});
    for(var i=0;i<allTabs.length;i++){
      if(allTabs[i].url&&allTabs[i].url.includes('upwork.com')&&allTabs[i].url.includes('search/talent')){
        upworkTab=allTabs[i];
        break;
      }
    }
  }
  
  if(!upworkTab){showStatus('No Upwork search tab found. Click "Open Upwork" first!','error');return;}
  
  try{await chrome.scripting.executeScript({target:{tabId:upworkTab.id},files:['js/content.js']});}catch(e){console.log('Script inject error:',e);}
  await new Promise(function(r){setTimeout(r,800);});
  
  chrome.tabs.sendMessage(upworkTab.id,{action:'scrapeProfiles'},function(resp){
    if(chrome.runtime.lastError){showStatus('Error: Refresh Upwork page and try again','error');console.log(chrome.runtime.lastError);return;}
    if(!resp||!resp.profiles||resp.profiles.length===0){showStatus('No profiles found. Make sure Upwork page is loaded.','error');return;}
    scrapedProfiles=resp.profiles; 
    displayScrapedProfiles();
    showStatus('Found '+scrapedProfiles.length+' competitors from Upwork!','success');
  });
}

function displayScrapedProfiles() {
  if(!scrapedProfiles.length){document.getElementById('scrapedData').classList.add('hidden');return;}
  document.getElementById('scrapedData').classList.remove('hidden');
  document.getElementById('scrapedCount').textContent=scrapedProfiles.length;
  document.getElementById('scrapedList').innerHTML=scrapedProfiles.map(function(p,i){return '<div class="scraped-item"><span>'+(i+1)+'. '+(p.title||'')+'</span><span>'+(p.rate?'$'+p.rate:'')+' '+(p.jss?p.jss+'%':'')+'</span></div>';}).join('');
  document.getElementById('competitorInput').value=scrapedProfiles.map(function(p){return p.title+(p.rate?' | $'+p.rate+'/hr':'')+(p.jss?' | '+p.jss+'%':'');}).join('\n');
}

function clearScraped() { scrapedProfiles=[]; document.getElementById('scrapedData').classList.add('hidden'); document.getElementById('competitorInput').value=''; }

async function doOptimize() {
  if(!APIService.hasCredits()){showModal('noCreditsModal');return;}
  var kw=document.getElementById('keyword').value.trim();
  if(!kw){showStatus('Enter keyword','error');return;}
  var comp=scrapedProfiles.length>=3?scrapedProfiles:[];
  if(!comp.length){var inp=document.getElementById('competitorInput').value.trim();if(inp)comp=inp.split('\n').map(function(l){var rm=l.match(/\$(\d+)/),jm=l.match(/(\d{2,3})%/);return{title:l.split('|')[0].trim(),rate:rm?rm[1]:'',jss:jm?jm[1]:''};}).filter(function(c){return c.title.length>5;});}
  var hasData=comp.length>=3;
  document.getElementById('optProgress').classList.remove('hidden');
  document.getElementById('optResults').classList.add('hidden');
  document.getElementById('optProgressFill').style.width='20%';
  document.getElementById('optProgressText').textContent='Analyzing TOP 10...';
  var curTitle=myProfile?myProfile.title:document.getElementById('myTitle').value.trim();
  var skills=myProfile?myProfile.skills:document.getElementById('mySkills').value.trim();
  var style=document.getElementById('optStyle').value;
  
  var prompt=`You are an expert Upwork profile optimizer. Analyze these TOP 10 competitors for "${kw}" and create a WINNING profile.

${hasData ? 'TOP 10 COMPETITORS:\n'+comp.map(function(c,i){return (i+1)+'. '+c.title+(c.rate?' | $'+c.rate+'/hr':'')+(c.jss?' | '+c.jss+'%':'');}).join('\n') : 'Generate realistic TOP 10 competitors for this niche with titles, rates ($XX/hr), and JSS (XX%)'}

My current title: ${curTitle||'Not set'}
My skills: ${skills||'Not specified'}
Style preference: ${style}

ANALYZE the competitors and provide:

===COMPETITORS===
List all 10 competitors with their Title | Rate | JSS

===PATTERNS===
5 winning patterns you found in successful profiles (what makes them rank high)

===KEYWORDS===
10 high-impact keywords found in top profiles (comma separated)

===TITLE===
Create an optimized title (60-70 characters) that:
- Includes primary keyword "${kw}"
- Uses power words from top competitors
- Stands out from competition

===DESCRIPTION===
Write a comprehensive Upwork profile description that is MINIMUM 4000 characters (around 700-800 words).

DESCRIPTION FORMAT - Follow this EXACT structure:

**OPENING HOOK (2-3 lines)**
Start with a powerful question or statement about client's problem. NO self-introduction here.

**WHAT I DO (1 paragraph)**
Clearly explain your expertise in ${kw}. Use keywords naturally.

**MY APPROACH (1 paragraph)**  
Explain your unique process/methodology. Be specific.

**SERVICES I OFFER (bullet points)**
✅ Service 1 - brief description
✅ Service 2 - brief description
✅ Service 3 - brief description
✅ Service 4 - brief description
✅ Service 5 - brief description

**RESULTS & ACHIEVEMENTS (1 paragraph)**
Mention specific numbers, percentages, achievements. Use metrics.

**WHY CLIENTS CHOOSE ME (bullet points)**
⭐ Reason 1
⭐ Reason 2
⭐ Reason 3

**TOOLS & TECHNOLOGIES (1 line)**
List relevant tools separated by | symbol

**CALL TO ACTION (2-3 lines)**
End with invitation to connect. Ask a question.

IMPORTANT RULES:
- Use keywords from ===KEYWORDS=== section naturally throughout
- Include emojis/symbols for visual appeal (✅ ⭐ 📈 💡 🎯 etc.)
- Make it scannable with clear sections
- Be specific, not generic
- Write in ${style} tone
- MUST be 4000+ characters

===IMPROVEMENTS===
5 specific improvements made compared to competitors`;

  document.getElementById('optProgressFill').style.width='50%';
  document.getElementById('optProgressText').textContent='AI analyzing & writing... (You can close this - it will continue in background)';
  var res=await APIService.generateAI(prompt,4000,'optimize');
  if(!res.success){document.getElementById('optProgress').classList.add('hidden');if(res.needCredits)showModal('noCreditsModal');else showStatus(res.error||'Failed','error');return;}
  var c=res.content||'';
  if(!hasData){var cs=extractSection(c,'===COMPETITORS===','===PATTERNS===');if(cs)comp=cs.split('\n').map(function(l){var rm=l.match(/\$(\d+)/),jm=l.match(/(\d{2,3})%/);return{title:l.replace(/^\d+\.\s*/,'').split('|')[0].trim(),rate:rm?rm[1]:'',jss:jm?jm[1]:''};}).filter(function(x){return x.title.length>5;});}
  var pats=extractSection(c,'===PATTERNS===','===KEYWORDS===').split('\n').filter(function(p){return p.trim().length>5;});
  var kws=extractSection(c,'===KEYWORDS===','===TITLE===').split(',').map(function(k){return k.trim();}).filter(function(k){return k;});
  var newT=extractSection(c,'===TITLE===','===DESCRIPTION===').trim();
  var newD=extractSection(c,'===DESCRIPTION===','===IMPROVEMENTS===').trim();
  var imps=extractSection(c,'===IMPROVEMENTS===','').split('\n').filter(function(i){return i.trim().length>5;});
  var rates=comp.map(function(x){return parseInt(x.rate)||0;}).filter(function(r){return r>0;});
  var jsses=comp.map(function(x){return parseInt(x.jss)||0;}).filter(function(j){return j>0;});
  var avgR=rates.length?Math.round(rates.reduce(function(a,b){return a+b;},0)/rates.length):0;
  var avgJ=jsses.length?Math.round(jsses.reduce(function(a,b){return a+b;},0)/jsses.length):0;
  document.getElementById('optProgress').classList.add('hidden');
  document.getElementById('optResults').classList.remove('hidden');
  document.getElementById('compAvgRate').textContent=avgR?'$'+avgR+'/hr':'-';
  document.getElementById('compRateRange').textContent=rates.length?'$'+Math.min.apply(null,rates)+'-$'+Math.max.apply(null,rates):'-';
  document.getElementById('compAvgJss').textContent=avgJ?avgJ+'%':'-';
  document.getElementById('competitorList').innerHTML=comp.slice(0,10).map(function(x,i){return '<div class="comp-item"><span class="rank">#'+(i+1)+'</span><span class="title">'+x.title+'</span><span class="rate">'+(x.rate?'$'+x.rate:'')+'</span><span class="jss">'+(x.jss?x.jss+'%':'')+'</span></div>';}).join('');
  document.getElementById('patternsList').innerHTML=pats.slice(0,5).map(function(p){return '<div class="pattern-item">'+p.replace(/^[\d\.\-\*]\s*/,'')+'</div>';}).join('');
  document.getElementById('keywordsList').innerHTML=kws.slice(0,10).map(function(k,i){return '<span class="kw-tag'+(i<3?' hot':'')+'">'+k+'</span>';}).join('');
  document.getElementById('beforeTitle').textContent=curTitle||'Not set';
  document.getElementById('afterTitle').textContent=newT||'-';
  document.getElementById('newTitle').textContent=newT;
  document.getElementById('newDesc').textContent=newD;
  document.getElementById('newTitleCount').textContent=newT.length+'/70';
  document.getElementById('newDescCount').textContent=newD.length+'/5000';
  document.getElementById('improvementsList').innerHTML=imps.slice(0,5).map(function(i){return '<li>'+i.replace(/^[\d\.\-\*]\s*/,'')+'</li>';}).join('');
  document.getElementById('credits').textContent='💎 '+res.credits;
  showStatus('Done!','success');
}

function extractSection(t,s,e){var i=t.indexOf(s);if(i===-1)return '';i+=s.length;var j=e?t.indexOf(e,i):t.length;if(j===-1)j=t.length;return t.substring(i,j).trim();}

// Handle optimization result (used for both live and restored results)
function handleOptimizeResult(content, credits) {
  var c = content || '';
  var comp = [];
  var cs = extractSection(c,'===COMPETITORS===','===PATTERNS===');
  if(cs) comp = cs.split('\n').map(function(l){var rm=l.match(/\$(\d+)/),jm=l.match(/(\d{2,3})%/);return{title:l.replace(/^\d+\.\s*/,'').split('|')[0].trim(),rate:rm?rm[1]:'',jss:jm?jm[1]:''};}).filter(function(x){return x.title.length>5;});
  
  var pats=extractSection(c,'===PATTERNS===','===KEYWORDS===').split('\n').filter(function(p){return p.trim().length>5;});
  var kws=extractSection(c,'===KEYWORDS===','===TITLE===').split(',').map(function(k){return k.trim();}).filter(function(k){return k;});
  var newT=extractSection(c,'===TITLE===','===DESCRIPTION===').trim();
  var newD=extractSection(c,'===DESCRIPTION===','===IMPROVEMENTS===').trim();
  var imps=extractSection(c,'===IMPROVEMENTS===','').split('\n').filter(function(i){return i.trim().length>5;});
  var rates=comp.map(function(x){return parseInt(x.rate)||0;}).filter(function(r){return r>0;});
  var jsses=comp.map(function(x){return parseInt(x.jss)||0;}).filter(function(j){return j>0;});
  var avgR=rates.length?Math.round(rates.reduce(function(a,b){return a+b;},0)/rates.length):0;
  var avgJ=jsses.length?Math.round(jsses.reduce(function(a,b){return a+b;},0)/jsses.length):0;
  
  document.getElementById('optProgress').classList.add('hidden');
  document.getElementById('optResults').classList.remove('hidden');
  document.getElementById('compAvgRate').textContent=avgR?'$'+avgR+'/hr':'-';
  document.getElementById('compRateRange').textContent=rates.length?'$'+Math.min.apply(null,rates)+'-$'+Math.max.apply(null,rates):'-';
  document.getElementById('compAvgJss').textContent=avgJ?avgJ+'%':'-';
  document.getElementById('competitorList').innerHTML=comp.slice(0,10).map(function(x,i){return '<div class="comp-item"><span class="rank">#'+(i+1)+'</span><span class="title">'+x.title+'</span><span class="rate">'+(x.rate?'$'+x.rate:'')+'</span><span class="jss">'+(x.jss?x.jss+'%':'')+'</span></div>';}).join('');
  document.getElementById('patternsList').innerHTML=pats.slice(0,5).map(function(p){return '<div class="pattern-item">'+p.replace(/^[\d\.\-\*]\s*/,'')+'</div>';}).join('');
  document.getElementById('keywordsList').innerHTML=kws.slice(0,10).map(function(k,i){return '<span class="kw-tag'+(i<3?' hot':'')+'">'+k+'</span>';}).join('');
  document.getElementById('newTitle').textContent=newT;
  document.getElementById('newDesc').textContent=newD;
  document.getElementById('newTitleCount').textContent=newT.length+'/70';
  document.getElementById('newDescCount').textContent=newD.length+'/5000';
  document.getElementById('improvementsList').innerHTML=imps.slice(0,5).map(function(i){return '<li>'+i.replace(/^[\d\.\-\*]\s*/,'')+'</li>';}).join('');
  
  if (credits !== undefined) {
    document.getElementById('credits').textContent='💎 '+credits;
  }
  
  // Switch to optimize tab
  switchTab('optimize');
}

function copyTitle(){navigator.clipboard.writeText(document.getElementById('newTitle').textContent);showStatus('Copied!','success');}
function copyDesc(){navigator.clipboard.writeText(document.getElementById('newDesc').textContent);showStatus('Copied!','success');}
function saveToProfile(){document.getElementById('myTitle').value=document.getElementById('newTitle').textContent;document.getElementById('myDesc').value=document.getElementById('newDesc').textContent;updateCharCounts();saveProfile();}
function saveOptToHistory(){saveToHistory('titles',{title:document.getElementById('newTitle').textContent,desc:document.getElementById('newDesc').textContent.substring(0,100),keyword:document.getElementById('keyword').value});}

async function genProposal() {
  if(!APIService.isPremium()){showModal('buyModal');return;}
  if(!APIService.hasCredits()){showModal('noCreditsModal');return;}
  var job=document.getElementById('jobDesc').value.trim();
  if(!job){showStatus('Enter job','error');return;}
  showStatus('Generating...','loading');
  var pi=document.getElementById('useProfile').checked&&myProfile?' My skills: '+(myProfile.skills||'')+'. Experience: '+(myProfile.exp||3)+' years.':'';
  var lens={short:'80-120',medium:'150-200',long:'250-350'};
  var tone=document.getElementById('propTone').value;
  var prompt=`Write a winning Upwork proposal for this job. 

JOB DESCRIPTION:
${job}

STRICT FORMAT - Follow this EXACTLY:

1. FIRST PARAGRAPH (2-3 lines): Start by directly addressing the client's PAIN POINT or PROBLEM from the job description. Show you understand their specific challenge. DO NOT start with "Hi", "Hello", "I am", "My name is" or any self-introduction.

2. SECOND PARAGRAPH (3-4 lines): Provide a brief SOLUTION or APPROACH to solve their problem. Be specific about HOW you will help them. Mention relevant technique or strategy.

3. THIRD PARAGRAPH (1-2 lines ONLY): Very brief about yourself - just mention your relevant experience in 1 short sentence. End with a question to engage the client.

RULES:
- NEVER start with self-introduction
- NEVER use generic phrases like "I am excited" or "I would love to"
- Start directly with their problem/pain point
- Be specific to THIS job, not generic
- Tone: ${tone}
- Total length: ${lens[document.getElementById('propLength').value]} words
${pi}

Write the proposal now:`;
  showStatus('Generating... (You can close - continues in background)','loading');
  var r=await APIService.generateAI(prompt,800,'proposal');
  if(!r.success){if(r.needCredits)showModal('noCreditsModal');else showStatus('Failed','error');return;}
  document.getElementById('proposalResult').classList.remove('hidden');
  document.getElementById('proposalText').textContent=r.content.trim();
  document.getElementById('credits').textContent='💎 '+r.credits;
  showStatus('Done!','success');
}
function copyProposal(){navigator.clipboard.writeText(document.getElementById('proposalText').textContent);showStatus('Copied!','success');}

function analyzeMarket() {
  var kw=document.getElementById('marketKeyword').value.trim().toLowerCase();
  if(!kw){showStatus('Enter keyword','error');return;}
  showStatus('Analyzing...','loading');
  
  // Market data based on common niches
  var marketData={
    'web development':{avg:45,min:25,max:150,success:89,skills:['JavaScript','React','Node.js','CSS','HTML']},
    'web developer':{avg:45,min:25,max:150,success:89,skills:['JavaScript','React','Node.js','CSS','HTML']},
    'react':{avg:55,min:30,max:175,success:91,skills:['React','Redux','TypeScript','Next.js','Tailwind']},
    'wordpress':{avg:35,min:15,max:100,success:87,skills:['WordPress','PHP','Elementor','WooCommerce','CSS']},
    'shopify':{avg:40,min:20,max:120,success:88,skills:['Shopify','Liquid','Theme Dev','Apps','SEO']},
    'mobile app':{avg:50,min:30,max:150,success:86,skills:['React Native','Flutter','iOS','Android','Firebase']},
    'python':{avg:50,min:25,max:150,success:90,skills:['Python','Django','Flask','Data Analysis','API']},
    'data science':{avg:65,min:35,max:200,success:88,skills:['Python','Machine Learning','SQL','Pandas','TensorFlow']},
    'machine learning':{avg:75,min:40,max:250,success:85,skills:['Python','TensorFlow','PyTorch','NLP','Deep Learning']},
    'graphic design':{avg:35,min:15,max:100,success:84,skills:['Photoshop','Illustrator','Figma','Logo Design','Branding']},
    'logo design':{avg:30,min:10,max:80,success:82,skills:['Illustrator','Photoshop','Branding','Vector','Typography']},
    'ui ux':{avg:50,min:25,max:150,success:87,skills:['Figma','Adobe XD','Prototyping','User Research','Wireframing']},
    'video editing':{avg:35,min:15,max:100,success:85,skills:['Premiere Pro','After Effects','DaVinci','Motion Graphics','Color Grading']},
    'seo':{avg:40,min:20,max:120,success:83,skills:['Keyword Research','On-Page SEO','Link Building','Analytics','Technical SEO']},
    'google ads':{avg:50,min:25,max:150,success:86,skills:['Google Ads','PPC','Analytics','Conversion Tracking','A/B Testing']},
    'facebook ads':{avg:45,min:20,max:130,success:84,skills:['Facebook Ads','Instagram Ads','Audience Targeting','Pixel','Retargeting']},
    'social media':{avg:30,min:15,max:80,success:81,skills:['Content Creation','Scheduling','Analytics','Engagement','Strategy']},
    'content writing':{avg:30,min:10,max:80,success:82,skills:['Blog Writing','SEO Writing','Copywriting','Research','Editing']},
    'copywriting':{avg:45,min:20,max:150,success:85,skills:['Sales Copy','Email Copy','Landing Pages','Headlines','A/B Testing']},
    'virtual assistant':{avg:20,min:8,max:50,success:88,skills:['Admin Support','Email Management','Scheduling','Data Entry','Research']},
    'bookkeeping':{avg:35,min:15,max:80,success:89,skills:['QuickBooks','Xero','Reconciliation','Invoicing','Financial Reports']},
    'accounting':{avg:45,min:25,max:120,success:90,skills:['QuickBooks','Financial Statements','Tax Prep','Payroll','Auditing']}
  };
  
  // Find matching data or generate estimate
  var data=null;
  for(var key in marketData){
    if(kw.includes(key)||key.includes(kw)){data=marketData[key];break;}
  }
  
  if(!data){
    // Generate reasonable estimates for unknown niches
    var base=Math.floor(Math.random()*20)+30;
    data={
      avg:base,
      min:Math.floor(base*0.5),
      max:Math.floor(base*3),
      success:Math.floor(Math.random()*10)+82,
      skills:['Communication','Problem Solving','Time Management','Attention to Detail','Collaboration']
    };
  }
  
  setTimeout(function(){
    document.getElementById('marketResult').classList.remove('hidden');
    document.getElementById('marketAvgRate').textContent='$'+data.avg+'/hr';
    document.getElementById('marketSuccess').textContent=data.success+'%';
    document.getElementById('marketRange').textContent='Range: $'+data.min+'-$'+data.max;
    document.getElementById('marketSkills').innerHTML=data.skills.map(function(s){return '<span class="kw-tag">'+s+'</span>';}).join('');
    showStatus('Done!','success');
  },500);
}

function calcScore() {
  var ti=document.getElementById('scoreTitle').value.trim();
  var de=document.getElementById('scoreDesc').value.trim();
  var kw=document.getElementById('scoreKeyword').value.trim().toLowerCase();
  
  if(!ti&&!de){showStatus('Enter title or desc','error');return;}
  showStatus('Scoring...','loading');
  
  setTimeout(function(){
    var titleScore=0,descScore=0,keywordScore=0,ctaScore=0,uniqueScore=0;
    var tips=[];
    
    // Title scoring (max 20)
    if(ti){
      if(ti.length>=40&&ti.length<=70)titleScore+=8;else if(ti.length>=20)titleScore+=4;
      if(ti.includes('Expert')||ti.includes('Specialist')||ti.includes('Professional'))titleScore+=4;
      if(ti.includes('|')||ti.includes('-'))titleScore+=3;
      if(/\d/.test(ti))titleScore+=3; // Has numbers
      if(ti.split(' ').length>=4)titleScore+=2;
    }
    if(titleScore<10)tips.push('Make title 40-70 chars with power words like Expert/Specialist');
    
    // Description scoring (max 20)
    if(de){
      if(de.length>=300)descScore+=5;else if(de.length>=100)descScore+=2;
      if(de.length>=500)descScore+=3;
      if(de.includes('✓')||de.includes('✔')||de.includes('•'))descScore+=3;
      if(/\d+%|\$\d+|\d+\+/.test(de))descScore+=4; // Has metrics
      if(de.split('\n').length>=3)descScore+=3;
      if(de.toLowerCase().includes('result')||de.toLowerCase().includes('help')||de.toLowerCase().includes('deliver'))descScore+=2;
    }
    if(descScore<10)tips.push('Add metrics, bullet points, and results in description');
    
    // Keyword scoring (max 20)
    if(kw&&(ti+' '+de).toLowerCase().includes(kw)){
      keywordScore+=10;
      var kwCount=((ti+' '+de).toLowerCase().match(new RegExp(kw,'g'))||[]).length;
      if(kwCount>=2)keywordScore+=5;
      if(kwCount>=4)keywordScore+=5;
    }else if(kw){
      keywordScore+=2;
    }else{
      keywordScore+=5; // No keyword specified
    }
    if(keywordScore<10)tips.push('Include target keyword 2-4 times naturally');
    
    // CTA scoring (max 20)
    var ctaWords=['contact','message','reach out','let\'s talk','hire','get in touch','discuss','start','ready'];
    ctaWords.forEach(function(w){if((ti+' '+de).toLowerCase().includes(w))ctaScore+=4;});
    ctaScore=Math.min(ctaScore,20);
    if(ctaScore<10)tips.push('Add a call-to-action like "Message me to discuss your project"');
    
    // Uniqueness scoring (max 20)
    if(ti&&!ti.toLowerCase().includes('freelancer'))uniqueScore+=5;
    if(de&&de.length>200)uniqueScore+=5;
    var uniqueWords=['guarantee','proven','certified','award','featured','published'];
    uniqueWords.forEach(function(w){if((ti+' '+de).toLowerCase().includes(w))uniqueScore+=3;});
    uniqueScore=Math.min(uniqueScore,20);
    if(uniqueScore<10)tips.push('Add unique selling points like certifications or achievements');
    
    // Ensure minimum scores
    if(ti)titleScore=Math.max(titleScore,5);
    if(de)descScore=Math.max(descScore,5);
    
    var total=titleScore+descScore+keywordScore+ctaScore+uniqueScore;
    
    document.getElementById('scoreResult').classList.remove('hidden');
    document.getElementById('totalScore').textContent=total;
    document.getElementById('scoreBreakdown').innerHTML='<div class="score-row"><span>Title</span><span>'+titleScore+'/20</span></div><div class="score-row"><span>Desc</span><span>'+descScore+'/20</span></div><div class="score-row"><span>Keywords</span><span>'+keywordScore+'/20</span></div><div class="score-row"><span>CTA</span><span>'+ctaScore+'/20</span></div><div class="score-row"><span>Unique</span><span>'+uniqueScore+'/20</span></div>';
    
    if(tips.length===0)tips=['Great job! Your profile is well optimized.','Consider A/B testing different titles.','Keep updating with new achievements.'];
    document.getElementById('scoreTips').innerHTML='<strong>Tips:</strong><br>1. '+tips[0]+'<br>2. '+(tips[1]||'Keep it professional')+'<br>3. '+(tips[2]||'Update regularly');
    showStatus('Done!','success');
  },500);
}

function calcRate() {
  var ni=document.getElementById('rateNiche').value.trim().toLowerCase();
  if(!ni){showStatus('Enter niche','error');return;}
  showStatus('Calculating...','loading');
  
  // Base rates by niche
  var nicheRates={
    'web development':{base:45},'web developer':{base:45},'react':{base:55},'angular':{base:55},
    'wordpress':{base:35},'shopify':{base:40},'wix':{base:25},'webflow':{base:45},
    'mobile app':{base:50},'ios':{base:60},'android':{base:55},'flutter':{base:50},'react native':{base:55},
    'python':{base:50},'java':{base:55},'php':{base:35},'ruby':{base:55},'golang':{base:65},
    'data science':{base:65},'machine learning':{base:75},'ai':{base:80},'data analyst':{base:50},
    'graphic design':{base:35},'logo design':{base:30},'ui ux':{base:50},'figma':{base:45},
    'video editing':{base:35},'animation':{base:45},'motion graphics':{base:50},
    'seo':{base:40},'google ads':{base:50},'facebook ads':{base:45},'ppc':{base:50},
    'social media':{base:30},'content writing':{base:30},'copywriting':{base:45},'blog':{base:25},
    'virtual assistant':{base:20},'data entry':{base:15},'admin':{base:20},
    'bookkeeping':{base:35},'accounting':{base:45},'financial':{base:55},
    'translation':{base:25},'transcription':{base:20},'voiceover':{base:40}
  };
  
  // Find base rate
  var baseRate=40;
  for(var key in nicheRates){
    if(ni.includes(key)||key.includes(ni)){baseRate=nicheRates[key].base;break;}
  }
  
  // Experience multiplier
  var exp=document.getElementById('rateExp').value;
  var expMultiplier=exp==='entry'?0.6:exp==='mid'?1:1.5;
  
  // Region multiplier
  var region=document.getElementById('rateRegion').value;
  var regionMultiplier=region==='asia'?0.5:region==='eu'?1.1:1.3;
  
  var lowRate=Math.round(baseRate*expMultiplier*regionMultiplier*0.7);
  var highRate=Math.round(baseRate*expMultiplier*regionMultiplier*1.3);
  
  // Advice based on experience
  var advice='';
  if(exp==='entry'){
    advice='Start lower to build reviews. Increase rate by $5 after every 5 jobs. Focus on getting your first 10 reviews quickly.';
  }else if(exp==='mid'){
    advice='Your rate is competitive. Highlight specific results in proposals. Consider specializing in a sub-niche for higher rates.';
  }else{
    advice='You can command premium rates. Lead with case studies and ROI metrics. Consider value-based pricing for larger projects.';
  }
  
  setTimeout(function(){
    document.getElementById('rateResult').classList.remove('hidden');
    document.getElementById('suggestedRate').textContent='$'+lowRate+' - $'+highRate+'/hr';
    document.getElementById('rateAdvice').textContent=advice;
    showStatus('Done!','success');
  },500);
}

function checkDensity() {
  var txt=document.getElementById('densityText').value.trim().toLowerCase(),kws=document.getElementById('densityKeywords').value.trim().toLowerCase();
  if(!txt||!kws){showStatus('Enter text and keywords','error');return;}
  var words=txt.split(/\s+/).length;
  document.getElementById('densityResult').classList.remove('hidden');
  document.getElementById('densityStats').innerHTML=kws.split(',').map(function(k){k=k.trim();var cnt=(txt.match(new RegExp('\\b'+k.replace(/[.*+?^${}()|[\]\\]/g,'\\$&')+'\\b','gi'))||[]).length,d=((cnt/words)*100).toFixed(2),cl=d<1?'low':(d>5?'high':'good');return '<div class="density-item"><span>'+k+'</span><span class="density-'+cl+'">'+cnt+'x ('+d+'%)</span></div>';}).join('');
  showStatus('Done!','success');
}

function updateProfileSelector(){var s=document.getElementById('profileSelect');s.innerHTML='';Object.keys(allProfiles).forEach(function(id){var o=document.createElement('option');o.value=id;o.textContent=id==='default'?'Default':(allProfiles[id]&&allProfiles[id].name||id);s.appendChild(o);});s.value=currentProfileId;}
function loadProfile(id){currentProfileId=id||'default';myProfile=allProfiles[currentProfileId]||null;if(myProfile){document.getElementById('myTitle').value=myProfile.title||'';document.getElementById('myDesc').value=myProfile.desc||'';document.getElementById('myNiche').value=myProfile.niche||'';document.getElementById('myExp').value=myProfile.exp||'';document.getElementById('mySkills').value=myProfile.skills||'';document.getElementById('myAchievements').value=myProfile.achievements||'';document.getElementById('saveStatus').textContent='Saved';document.getElementById('saveStatus').className='badge badge-success';}else{document.getElementById('myTitle').value='';document.getElementById('myDesc').value='';document.getElementById('myNiche').value='';document.getElementById('myExp').value='';document.getElementById('mySkills').value='';document.getElementById('myAchievements').value='';document.getElementById('saveStatus').textContent='Not Saved';document.getElementById('saveStatus').className='badge';}chrome.storage.local.set({currentProfileId:currentProfileId});updateCharCounts();}
function saveProfile(){myProfile={name:currentProfileId==='default'?'Default':(allProfiles[currentProfileId]&&allProfiles[currentProfileId].name||currentProfileId),title:document.getElementById('myTitle').value.trim(),desc:document.getElementById('myDesc').value.trim(),niche:document.getElementById('myNiche').value.trim(),exp:document.getElementById('myExp').value,skills:document.getElementById('mySkills').value.trim(),achievements:document.getElementById('myAchievements').value.trim(),updatedAt:new Date().toISOString()};allProfiles[currentProfileId]=myProfile;chrome.storage.local.set({allProfiles:allProfiles});document.getElementById('saveStatus').textContent='Saved';document.getElementById('saveStatus').className='badge badge-success';showStatus('Saved!','success');}
function createNewProfile(){var nm=document.getElementById('newProfileName').value.trim();if(!nm){showStatus('Enter name','error');return;}var id='profile_'+Date.now();allProfiles[id]={name:nm};chrome.storage.local.set({allProfiles:allProfiles});loadProfile(id);updateProfileSelector();hideModal('newProfileModal');document.getElementById('newProfileName').value='';showStatus('Created!','success');}
function updateCharCounts(){document.getElementById('titleCount').textContent=document.getElementById('myTitle').value.length;document.getElementById('descCount').textContent=document.getElementById('myDesc').value.length;}
function exportProfile(){var b=new Blob([JSON.stringify(myProfile,null,2)],{type:'application/json'});var a=document.createElement('a');a.href=URL.createObjectURL(b);a.download='profile.json';a.click();showStatus('Exported!','success');}
function importProfile(){document.getElementById('importFile').click();}
function handleImport(e){var f=e.target.files[0];if(!f)return;var r=new FileReader();r.onload=function(ev){try{var d=JSON.parse(ev.target.result);document.getElementById('myTitle').value=d.title||'';document.getElementById('myDesc').value=d.desc||'';document.getElementById('myNiche').value=d.niche||'';document.getElementById('myExp').value=d.exp||'';document.getElementById('mySkills').value=d.skills||'';document.getElementById('myAchievements').value=d.achievements||'';updateCharCounts();showStatus('Imported!','success');}catch(err){showStatus('Invalid file','error');}};r.readAsText(f);}

function loadHistory(type){type=type||'profiles';var list=history[type]||[];document.querySelectorAll('.history-tab').forEach(function(t){t.classList.remove('active');});var at=document.querySelector('.history-tab[data-type="'+type+'"]');if(at)at.classList.add('active');var el=document.getElementById('historyList');if(!list.length){el.innerHTML='<p class="empty">No '+type+' yet</p>';return;}el.innerHTML=list.map(function(item,i){return '<div class="history-item"><div class="date">'+new Date(item.date).toLocaleDateString()+'</div><div class="title">'+(item.title||item.keyword||'Item')+'</div><button class="btn-small btn-secondary hist-use" data-type="'+type+'" data-index="'+i+'">Use</button> <button class="btn-small btn-danger hist-del" data-type="'+type+'" data-index="'+i+'">Del</button></div>';}).join('');document.querySelectorAll('.hist-use').forEach(function(b){b.addEventListener('click',function(){useHistory(b.dataset.type,parseInt(b.dataset.index));});});document.querySelectorAll('.hist-del').forEach(function(b){b.addEventListener('click',function(){deleteHistory(b.dataset.type,parseInt(b.dataset.index));});});}
function saveToHistory(type,data){if(!history[type])history[type]=[];data.date=new Date().toISOString();history[type].unshift(data);if(history[type].length>20)history[type]=history[type].slice(0,20);chrome.storage.local.set({history:history});showStatus('Saved!','success');}
function useHistory(type,i){var item=history[type][i];if(type==='titles'){document.getElementById('newTitle').textContent=item.title||'';document.getElementById('newDesc').textContent=item.desc||'';document.getElementById('optResults').classList.remove('hidden');switchTab('optimize');}showStatus('Loaded!','success');}
function deleteHistory(type,i){history[type].splice(i,1);chrome.storage.local.set({history:history});loadHistory(type);}
function clearHistory(){if(!confirm('Clear all?'))return;history={profiles:[],proposals:[],titles:[]};chrome.storage.local.set({history:history});loadHistory('profiles');showStatus('Cleared!','success');}

function loadData(){chrome.storage.local.get(['allProfiles','currentProfileId','history'],function(r){allProfiles=r.allProfiles||{default:null};currentProfileId=r.currentProfileId||'default';history=r.history||{profiles:[],proposals:[],titles:[]};loadProfile(currentProfileId);updateProfileSelector();loadHistory('profiles');});}

function setupEvents(){
  // Auth links
  document.getElementById('signupLink').addEventListener('click',function(e){e.preventDefault();showSignupForm();});
  document.getElementById('loginLink').addEventListener('click',function(e){e.preventDefault();showLoginForm();});
  document.getElementById('forgotLink').addEventListener('click',function(e){e.preventDefault();showForgotForm();});
  document.getElementById('backToLoginLink').addEventListener('click',function(e){e.preventDefault();showLoginForm();});
  document.getElementById('backToSignupLink').addEventListener('click',function(e){e.preventDefault();showSignupForm();});
  document.getElementById('backToForgotLink').addEventListener('click',function(e){e.preventDefault();showForgotForm();});
  document.getElementById('resendLink').addEventListener('click',function(e){e.preventDefault();doResendOtp();});
  
  // Auth buttons
  document.getElementById('loginBtn').addEventListener('click',doLogin);
  document.getElementById('signupBtn').addEventListener('click',doSignup);
  document.getElementById('verifyOtpBtn').addEventListener('click',doVerifyOtp);
  document.getElementById('sendResetBtn').addEventListener('click',doSendReset);
  document.getElementById('resetPasswordBtn').addEventListener('click',doResetPassword);
  document.getElementById('loginPassword').addEventListener('keypress',function(e){if(e.key==='Enter')doLogin();});
  document.getElementById('signupPassword').addEventListener('keypress',function(e){if(e.key==='Enter')doSignup();});
  
  // Main app
  document.getElementById('closeBtn').addEventListener('click',function(){window.close();});
  document.getElementById('buyCreditsBtn').addEventListener('click',function(){showModal('buyModal');});
  document.getElementById('warningBuyBtn').addEventListener('click',function(){showModal('buyModal');});
  
  // Profile
  document.getElementById('saveProfileBtn').addEventListener('click',saveProfile);
  document.getElementById('exportBtn').addEventListener('click',exportProfile);
  document.getElementById('importBtn').addEventListener('click',importProfile);
  document.getElementById('importFile').addEventListener('change',handleImport);
  document.getElementById('newProfileBtn').addEventListener('click',function(){showModal('newProfileModal');});
  document.getElementById('createProfileBtn').addEventListener('click',createNewProfile);
  document.getElementById('profileSelect').addEventListener('change',function(){loadProfile(this.value);});
  document.getElementById('myTitle').addEventListener('input',updateCharCounts);
  document.getElementById('myDesc').addEventListener('input',updateCharCounts);
  
  // Optimize
  document.getElementById('openUpworkBtn').addEventListener('click',openUpworkSearch);
  document.getElementById('scrapeBtn').addEventListener('click',scrapeCompetitors);
  document.getElementById('clearScrapedBtn').addEventListener('click',clearScraped);
  document.getElementById('toggleManualBtn').addEventListener('click',function(){document.getElementById('manualInput').classList.toggle('hidden');});
  document.getElementById('optimizeBtn').addEventListener('click',doOptimize);
  document.getElementById('copyTitleBtn').addEventListener('click',copyTitle);
  document.getElementById('copyDescBtn').addEventListener('click',copyDesc);
  document.getElementById('saveToProfileBtn').addEventListener('click',saveToProfile);
  document.getElementById('saveToHistoryBtn').addEventListener('click',saveOptToHistory);
  
  // Proposal
  document.getElementById('unlockProposalBtn').addEventListener('click',function(){showModal('buyModal');});
  document.getElementById('genProposalBtn').addEventListener('click',genProposal);
  document.getElementById('copyProposalBtn').addEventListener('click',copyProposal);
  document.getElementById('regenProposalBtn').addEventListener('click',genProposal);
  
  // Tools
  document.getElementById('analyzeMarketBtn').addEventListener('click',analyzeMarket);
  document.getElementById('calcScoreBtn').addEventListener('click',calcScore);
  document.getElementById('calcRateBtn').addEventListener('click',calcRate);
  document.getElementById('checkDensityBtn').addEventListener('click',checkDensity);
  
  // History
  document.querySelectorAll('.history-tab').forEach(function(t){t.addEventListener('click',function(){loadHistory(t.dataset.type);});});
  document.getElementById('clearHistoryBtn').addEventListener('click',clearHistory);
  
  // Settings
  document.getElementById('logoutBtn').addEventListener('click',async function(){await APIService.logout();showAuth();});
  document.getElementById('clearDataBtn').addEventListener('click',function(){if(confirm('Clear all?')){chrome.storage.local.remove(['allProfiles','history'],function(){allProfiles={default:null};history={profiles:[],proposals:[],titles:[]};loadProfile('default');showStatus('Cleared!','success');});}});
  
  // Tabs
  document.querySelectorAll('.tab').forEach(function(t){t.addEventListener('click',function(){switchTab(t.dataset.tab);});});
  
  // Modals
  document.getElementById('welcomeCloseBtn').addEventListener('click',function(){hideModal('welcomeModal');});
  document.getElementById('buyModalCloseBtn').addEventListener('click',function(){hideModal('buyModal');});
  document.getElementById('noCreditsToPayBtn').addEventListener('click',function(){hideModal('noCreditsModal');showModal('buyModal');});
  document.getElementById('noCreditsCloseBtn').addEventListener('click',function(){hideModal('noCreditsModal');});
  document.getElementById('newProfileCloseBtn').addEventListener('click',function(){hideModal('newProfileModal');});
}

function switchTab(name){document.querySelectorAll('.tab').forEach(function(t){t.classList.remove('active');});document.querySelectorAll('.panel').forEach(function(p){p.classList.add('hidden');});document.querySelector('[data-tab="'+name+'"]').classList.add('active');document.getElementById(name+'Tab').classList.remove('hidden');}
