// UPWORK PRO v6.1 - Content Script for Scraping
(function() {
  console.log('[Upwork Pro] Content script loaded');

  chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
    if (request.action === 'scrapeProfiles') {
      var profiles = scrapeProfiles();
      sendResponse({ success: true, profiles: profiles });
    }
    return true;
  });

  function scrapeProfiles() {
    var profiles = [];
    var cards = document.querySelectorAll('[data-test="freelancer-tile"], article, .up-card-section');
    
    cards.forEach(function(card, i) {
      if (profiles.length >= 10) return;
      
      var text = card.textContent || '';
      var title = '';
      var rate = '';
      var jss = '';
      
      // Get title
      var titleEl = card.querySelector('h4, [data-test="tile-title"], .freelancer-title');
      if (titleEl) title = titleEl.textContent.trim();
      
      // Get rate
      var rateMatch = text.match(/\$(\d+(?:\.\d+)?)\s*\/\s*hr/i);
      if (rateMatch) rate = rateMatch[1];
      
      // Get JSS
      var jssMatch = text.match(/(\d{2,3})%\s*(?:Job Success|success)/i);
      if (jssMatch) jss = jssMatch[1];
      
      if (title && title.length > 5) {
        profiles.push({ title: title, rate: rate, jss: jss });
      }
    });
    
    return profiles;
  }
})();
